 ; Look - trim and erase entities out of a rectangle.
 ; Copyright 1994 by Rocket Software
 ; Plan ahead - leave a space for coffee rings.
 (DEFUN C:LOOK (/ pas pa pbs pb bb dd plin snapp osm high wid hincr wincr vang
                                                                        horang)
  (setvar "cmdecho" 0)
  (command "undo" "m")
  (setq pas (setq pa (getpoint "First corner: ")))
  (setq pbs (setq pb (getcorner pa "and second: ")))
  (setq bb (cons (car pb) (cdr pa)))
  (setq dd (cons (car pa) (cdr pb)))
  (command "pline" pa bb pb dd "c")
  (setq plin (entlast))
  (setq snapp (getvar "snapmode"))
  (setvar "snapmode" 0)
  (setq osm (getvar "osmode"))
  (setvar "osmode" 0)
  (setq high (abs (- (cadr pa) (cadr pb))))
  (setq wid (abs (- (car pa) (car pb))))
  (setq hincr (/ high 11))
  (setq wincr (/ wid 11))
  (setq high (- high hincr))
  (setq pa (polar pa (setq vang (angle (list 0 (cadr pa))
                                       (list 0 (cadr pb)))) hincr))
  (setq horang (angle (list (car pa) 0) (list (car pb) 0)))
  (command "trim" "l" "" "f" pa)
  (repeat 9
         (setq wid (- wid wincr))
         (command (setq pa (polar pa horang wid)))
         (setq horang (+ horang pi))
         (setq high (- high hincr))
         (command (setq pa (polar pa vang high)))
         (setq vang (+ vang pi)))
  (command "" "")
  (command "erase" "w" pas pbs "")
  (setvar "snapmode" snapp)
  (setvar "osmode" osm)
 (princ))